within AixLib.ThermalZones.ReducedOrder.Windows.Validation.VDI2078;
model TestCase3_VentilationHeat
  extends Modelica.Icons.Example;

  AixLib.ThermalZones.ReducedOrder.Windows.BaseClasses.VentilationHeat ventilationHeat(
    x_f=0.8,
    d=0.1,
    screen=false,
    tau_e=0,
    rho_e=0.8125,
    til=1.5707963267949)
    "Calculates the heat input due to ventialtion for test case 3 of VDI2078"
    annotation (Placement(transformation(extent={{80,-10},{100,10}})));
  AixLib.ThermalZones.ReducedOrder.Windows.BaseClasses.Sunblind sunblind(lim=200)
    "Calculates if the sunblind of the window is active"
    annotation (Placement(transformation(extent={{48,-2},{56,6}})));
  Modelica.Blocks.Sources.CombiTimeTable HDirHor(
    columns={2},
    tableName="HDirHor",
    smoothness=Modelica.Blocks.Types.Smoothness.ConstantSegments,
    tableOnFile=false,
    table=[0,0; 3600,0; 7200,0; 10800,0; 14400,0; 18000,0; 21600,0; 25200,
        6.97804373; 28800,45.26143833; 32400,110.4153032; 36000,186.2726158;
        39600,255.5241448; 43200,302.9030765; 46800,318.0561637; 50400,
        297.6769067; 54000,246.2124597; 57600,174.9154955; 61200,99.54837583;
        64800,37.47098217; 68400,4.241288132; 72000,0; 75600,0; 79200,0; 82800,
        0; 86400,0; 90000,0; 93600,0; 97200,0; 100800,0; 104400,0; 108000,0;
        111600,6.97804373; 115200,45.26143833; 118800,110.4153032; 122400,
        186.2726158; 126000,255.5241448; 129600,302.9030765; 133200,318.0561637;
        136800,297.6769067; 140400,246.2124597; 144000,174.9154955; 147600,
        99.54837583; 151200,37.47098217; 154800,4.241288132; 158400,0; 162000,0;
        165600,0; 169200,0; 172800,0; 176400,0; 180000,0; 183600,0; 187200,0;
        190800,0; 194400,0; 198000,6.97804373; 201600,45.26143833; 205200,
        110.4153032; 208800,186.2726158; 212400,255.5241448; 216000,302.9030765;
        219600,318.0561637; 223200,297.6769067; 226800,246.2124597; 230400,
        174.9154955; 234000,99.54837583; 237600,37.47098217; 241200,4.241288132;
        244800,0; 248400,0; 252000,0; 255600,0; 259200,0; 262800,0; 266400,0;
        270000,0; 273600,0; 277200,0; 280800,0; 284400,6.97804373; 288000,
        45.26143833; 291600,110.4153032; 295200,186.2726158; 298800,255.5241448;
        302400,302.9030765; 306000,318.0561637; 309600,297.6769067; 313200,
        246.2124597; 316800,174.9154955; 320400,99.54837583; 324000,37.47098217;
        327600,4.241288132; 331200,0; 334800,0; 338400,0; 342000,0; 345600,0;
        349200,0; 352800,0; 356400,0; 360000,0; 363600,0; 367200,0; 370800,
        6.97804373; 374400,45.26143833; 378000,110.4153032; 381600,186.2726158;
        385200,255.5241448; 388800,302.9030765; 392400,318.0561637; 396000,
        297.6769067; 399600,246.2124597; 403200,174.9154955; 406800,99.54837583;
        410400,37.47098217; 414000,4.241288132; 417600,0; 421200,0; 424800,0;
        428400,0; 432000,0; 435600,0; 439200,0; 442800,0; 446400,0; 450000,0;
        453600,0; 457200,6.97804373; 460800,45.26143833; 464400,110.4153032;
        468000,186.2726158; 471600,255.5241448; 475200,302.9030765; 478800,
        318.0561637; 482400,297.6769067; 486000,246.2124597; 489600,174.9154955;
        493200,99.54837583; 496800,37.47098217; 500400,4.241288132; 504000,0;
        507600,0; 511200,0; 514800,0; 518400,0; 522000,0; 525600,0; 529200,0;
        532800,0; 536400,0; 540000,0; 543600,6.97804373; 547200,45.26143833;
        550800,110.4153032; 554400,186.2726158; 558000,255.5241448; 561600,
        302.9030765; 565200,318.0561637; 568800,297.6769067; 572400,246.2124597;
        576000,174.9154955; 579600,99.54837583; 583200,37.47098217; 586800,
        4.241288132; 590400,0; 594000,0; 597600,0; 601200,0; 604800,0; 608400,0;
        612000,0; 615600,0; 619200,0; 622800,0; 626400,0; 630000,6.97804373;
        633600,45.26143833; 637200,110.4153032; 640800,186.2726158; 644400,
        255.5241448; 648000,302.9030765; 651600,318.0561637; 655200,297.6769067;
        658800,246.2124597; 662400,174.9154955; 666000,99.54837583; 669600,
        37.47098217; 673200,4.241288132; 676800,0; 680400,0; 684000,0; 687600,0;
        691200,0; 694800,0; 698400,0; 702000,0; 705600,0; 709200,0; 712800,0;
        716400,6.97804373; 720000,45.26143833; 723600,110.4153032; 727200,
        186.2726158; 730800,255.5241448; 734400,302.9030765; 738000,318.0561637;
        741600,297.6769067; 745200,246.2124597; 748800,174.9154955; 752400,
        99.54837583; 756000,37.47098217; 759600,4.241288132; 763200,0; 766800,0;
        770400,0; 774000,0; 777600,0; 781200,0; 784800,0; 788400,0; 792000,0;
        795600,0; 799200,0; 802800,6.97804373; 806400,45.26143833; 810000,
        110.4153032; 813600,186.2726158; 817200,255.5241448; 820800,302.9030765;
        824400,318.0561637; 828000,297.6769067; 831600,246.2124597; 835200,
        174.9154955; 838800,99.54837583; 842400,37.47098217; 846000,4.241288132;
        849600,0; 853200,0; 856800,0; 860400,0; 864000,0; 867600,0; 871200,0;
        874800,0; 878400,0; 882000,0; 885600,0; 889200,6.97804373; 892800,
        45.26143833; 896400,110.4153032; 900000,186.2726158; 903600,255.5241448;
        907200,302.9030765; 910800,318.0561637; 914400,297.6769067; 918000,
        246.2124597; 921600,174.9154955; 925200,99.54837583; 928800,37.47098217;
        932400,4.241288132; 936000,0; 939600,0; 943200,0; 946800,0; 950400,0;
        954000,0; 957600,0; 961200,0; 964800,0; 968400,0; 972000,0; 975600,
        6.97804373; 979200,45.26143833; 982800,110.4153032; 986400,186.2726158;
        990000,255.5241448; 993600,302.9030765; 997200,318.0561637; 1000800,
        297.6769067; 1004400,246.2124597; 1008000,174.9154955; 1011600,
        99.54837583; 1015200,37.47098217; 1018800,4.241288132; 1022400,0;
        1026000,0; 1029600,0; 1033200,0; 1036800,0; 1040400,0; 1044000,0;
        1047600,0; 1051200,0; 1054800,0; 1058400,0; 1062000,6.97804373; 1065600,
        45.26143833; 1069200,110.4153032; 1072800,186.2726158; 1076400,
        255.5241448; 1080000,302.9030765; 1083600,318.0561637; 1087200,
        297.6769067; 1090800,246.2124597; 1094400,174.9154955; 1098000,
        99.54837583; 1101600,37.47098217; 1105200,4.241288132; 1108800,0;
        1112400,0; 1116000,0; 1119600,0; 1123200,0; 1126800,0; 1130400,0;
        1134000,0; 1137600,0; 1141200,0; 1144800,0; 1148400,6.97804373; 1152000,
        45.26143833; 1155600,110.4153032; 1159200,186.2726158; 1162800,
        255.5241448; 1166400,302.9030765; 1170000,318.0561637; 1173600,
        297.6769067; 1177200,246.2124597; 1180800,174.9154955; 1184400,
        99.54837583; 1188000,37.47098217; 1191600,4.241288132; 1195200,0;
        1198800,0; 1202400,0; 1206000,0; 1209600,0; 1213200,0; 1216800,0;
        1220400,0; 1224000,0; 1227600,0; 1231200,0; 1234800,39.07398846;
        1238400,164.3396228; 1242000,319.1618766; 1245600,466.1278073; 1249200,
        583.2867887; 1252800,657.0058834; 1256400,679.6830794; 1260000,
        649.0893148; 1263600,568.2428437; 1267200,445.5861318; 1270800,
        295.7855335; 1274400,142.4655924; 1278000,26.47655754; 1281600,0;
        1285200,0; 1288800,0; 1292400,0; 1296000,0; 1299600,0; 1303200,0;
        1306800,0; 1310400,0; 1314000,0; 1317600,0; 1321200,39.07398846;
        1324800,164.3396228; 1328400,319.1618766; 1332000,466.1278073; 1335600,
        583.2867887; 1339200,657.0058834; 1342800,679.6830794; 1346400,
        649.0893148; 1350000,568.2428437; 1353600,445.5861318; 1357200,
        295.7855335; 1360800,142.4655924; 1364400,26.47655754; 1368000,0;
        1371600,0; 1375200,0; 1378800,0; 1382400,0; 1386000,0; 1389600,0;
        1393200,0; 1396800,0; 1400400,0; 1404000,0; 1407600,39.07398846;
        1411200,164.3396228; 1414800,319.1618766; 1418400,466.1278073; 1422000,
        583.2867887; 1425600,657.0058834; 1429200,679.6830794; 1432800,
        649.0893148; 1436400,568.2428437; 1440000,445.5861318; 1443600,
        295.7855335; 1447200,142.4655924; 1450800,26.47655754; 1454400,0;
        1458000,0; 1461600,0; 1465200,0; 1468800,0; 1472400,0; 1476000,0;
        1479600,0; 1483200,0; 1486800,0; 1490400,0; 1494000,39.07398846;
        1497600,164.3396228; 1501200,319.1618766; 1504800,466.1278073; 1508400,
        583.2867887; 1512000,657.0058834; 1515600,679.6830794; 1519200,
        649.0893148; 1522800,568.2428437; 1526400,445.5861318; 1530000,
        295.7855335; 1533600,142.4655924; 1537200,26.47655754; 1540800,0;
        1544400,0; 1548000,0; 1551600,0; 1555200,0; 1558800,0; 1562400,0;
        1566000,0; 1569600,0; 1573200,0; 1576800,0; 1580400,39.07398846;
        1584000,164.3396228; 1587600,319.1618766; 1591200,466.1278073; 1594800,
        583.2867887; 1598400,657.0058834; 1602000,679.6830794; 1605600,
        649.0893148; 1609200,568.2428437; 1612800,445.5861318; 1616400,
        295.7855335; 1620000,142.4655924; 1623600,26.47655754; 1627200,0;
        1630800,0; 1634400,0; 1638000,0])
    "Direct irradiation on horizontal surface"
    annotation (Placement(transformation(extent={{-96,-26},{-82,-12}})));
  Modelica.Blocks.Sources.CombiTimeTable alt(
    columns={2},
    tableName="alt",
    smoothness=Modelica.Blocks.Types.Smoothness.ConstantSegments,
    tableOnFile=false,
    table=[0,-0.524971501; 3600,-0.540504674; 7200,-0.511513997; 10800,-0.436196642;
        14400,-0.323752929; 18000,-0.184550738; 21600,-0.027807643; 25200,
        0.138810415; 28800,0.308550932; 32400,0.474473156; 36000,
        0.627965928; 39600,0.756893419; 43200,0.844457705; 46800,
        0.872876752; 50400,0.834722167; 54000,0.739755433; 57600,
        0.606187916; 61200,0.450168115; 64800,0.28318588; 68400,
        0.113490388; 72000,-0.052089885; 75600,-0.206727187; 79200,-0.342547809;
        82800,-0.450098665; 86400,-0.524971501; 90000,-0.540504674; 93600,
        -0.511513997; 97200,-0.436196642; 100800,-0.323752929; 104400,-0.184550738;
        108000,-0.027807643; 111600,0.138810415; 115200,0.308550932;
        118800,0.474473156; 122400,0.627965928; 126000,0.756893419;
        129600,0.844457705; 133200,0.872876752; 136800,0.834722167;
        140400,0.739755433; 144000,0.606187916; 147600,0.450168115;
        151200,0.28318588; 154800,0.113490388; 158400,-0.052089885;
        162000,-0.206727187; 165600,-0.342547809; 169200,-0.450098665;
        172800,-0.524971501; 176400,-0.540504674; 180000,-0.511513997;
        183600,-0.436196642; 187200,-0.323752929; 190800,-0.184550738;
        194400,-0.027807643; 198000,0.138810415; 201600,0.308550932;
        205200,0.474473156; 208800,0.627965928; 212400,0.756893419;
        216000,0.844457705; 219600,0.872876752; 223200,0.834722167;
        226800,0.739755433; 230400,0.606187916; 234000,0.450168115;
        237600,0.28318588; 241200,0.113490388; 244800,-0.052089885;
        248400,-0.206727187; 252000,-0.342547809; 255600,-0.450098665;
        259200,-0.524971501; 262800,-0.540504674; 266400,-0.511513997;
        270000,-0.436196642; 273600,-0.323752929; 277200,-0.184550738;
        280800,-0.027807643; 284400,0.138810415; 288000,0.308550932;
        291600,0.474473156; 295200,0.627965928; 298800,0.756893419;
        302400,0.844457705; 306000,0.872876752; 309600,0.834722167;
        313200,0.739755433; 316800,0.606187916; 320400,0.450168115;
        324000,0.28318588; 327600,0.113490388; 331200,-0.052089885;
        334800,-0.206727187; 338400,-0.342547809; 342000,-0.450098665;
        345600,-0.524971501; 349200,-0.540504674; 352800,-0.511513997;
        356400,-0.436196642; 360000,-0.323752929; 363600,-0.184550738;
        367200,-0.027807643; 370800,0.138810415; 374400,0.308550932;
        378000,0.474473156; 381600,0.627965928; 385200,0.756893419;
        388800,0.844457705; 392400,0.872876752; 396000,0.834722167;
        399600,0.739755433; 403200,0.606187916; 406800,0.450168115;
        410400,0.28318588; 414000,0.113490388; 417600,-0.052089885;
        421200,-0.206727187; 424800,-0.342547809; 428400,-0.450098665;
        432000,-0.524971501; 435600,-0.540504674; 439200,-0.511513997;
        442800,-0.436196642; 446400,-0.323752929; 450000,-0.184550738;
        453600,-0.027807643; 457200,0.138810415; 460800,0.308550932;
        464400,0.474473156; 468000,0.627965928; 471600,0.756893419;
        475200,0.844457705; 478800,0.872876752; 482400,0.834722167;
        486000,0.739755433; 489600,0.606187916; 493200,0.450168115;
        496800,0.28318588; 500400,0.113490388; 504000,-0.052089885;
        507600,-0.206727187; 511200,-0.342547809; 514800,-0.450098665;
        518400,-0.524971501; 522000,-0.540504674; 525600,-0.511513997;
        529200,-0.436196642; 532800,-0.323752929; 536400,-0.184550738;
        540000,-0.027807643; 543600,0.138810415; 547200,0.308550932;
        550800,0.474473156; 554400,0.627965928; 558000,0.756893419;
        561600,0.844457705; 565200,0.872876752; 568800,0.834722167;
        572400,0.739755433; 576000,0.606187916; 579600,0.450168115;
        583200,0.28318588; 586800,0.113490388; 590400,-0.052089885;
        594000,-0.206727187; 597600,-0.342547809; 601200,-0.450098665;
        604800,-0.524971501; 608400,-0.540504674; 612000,-0.511513997;
        615600,-0.436196642; 619200,-0.323752929; 622800,-0.184550738;
        626400,-0.027807643; 630000,0.138810415; 633600,0.308550932;
        637200,0.474473156; 640800,0.627965928; 644400,0.756893419;
        648000,0.844457705; 651600,0.872876752; 655200,0.834722167;
        658800,0.739755433; 662400,0.606187916; 666000,0.450168115;
        669600,0.28318588; 673200,0.113490388; 676800,-0.052089885;
        680400,-0.206727187; 684000,-0.342547809; 687600,-0.450098665;
        691200,-0.524971501; 694800,-0.540504674; 698400,-0.511513997;
        702000,-0.436196642; 705600,-0.323752929; 709200,-0.184550738;
        712800,-0.027807643; 716400,0.138810415; 720000,0.308550932;
        723600,0.474473156; 727200,0.627965928; 730800,0.756893419;
        734400,0.844457705; 738000,0.872876752; 741600,0.834722167;
        745200,0.739755433; 748800,0.606187916; 752400,0.450168115;
        756000,0.28318588; 759600,0.113490388; 763200,-0.052089885;
        766800,-0.206727187; 770400,-0.342547809; 774000,-0.450098665;
        777600,-0.524971501; 781200,-0.540504674; 784800,-0.511513997;
        788400,-0.436196642; 792000,-0.323752929; 795600,-0.184550738;
        799200,-0.027807643; 802800,0.138810415; 806400,0.308550932;
        810000,0.474473156; 813600,0.627965928; 817200,0.756893419;
        820800,0.844457705; 824400,0.872876752; 828000,0.834722167;
        831600,0.739755433; 835200,0.606187916; 838800,0.450168115;
        842400,0.28318588; 846000,0.113490388; 849600,-0.052089885;
        853200,-0.206727187; 856800,-0.342547809; 860400,-0.450098665;
        864000,-0.524971501; 867600,-0.540504674; 871200,-0.511513997;
        874800,-0.436196642; 878400,-0.323752929; 882000,-0.184550738;
        885600,-0.027807643; 889200,0.138810415; 892800,0.308550932;
        896400,0.474473156; 900000,0.627965928; 903600,0.756893419;
        907200,0.844457705; 910800,0.872876752; 914400,0.834722167;
        918000,0.739755433; 921600,0.606187916; 925200,0.450168115;
        928800,0.28318588; 932400,0.113490388; 936000,-0.052089885;
        939600,-0.206727187; 943200,-0.342547809; 946800,-0.450098665;
        950400,-0.524971501; 954000,-0.540504674; 957600,-0.511513997;
        961200,-0.436196642; 964800,-0.323752929; 968400,-0.184550738;
        972000,-0.027807643; 975600,0.138810415; 979200,0.308550932;
        982800,0.474473156; 986400,0.627965928; 990000,0.756893419;
        993600,0.844457705; 997200,0.872876752; 1000800,0.834722167;
        1004400,0.739755433; 1008000,0.606187916; 1011600,0.450168115;
        1015200,0.28318588; 1018800,0.113490388; 1022400,-0.052089885;
        1026000,-0.206727187; 1029600,-0.342547809; 1033200,-0.450098665;
        1036800,-0.524971501; 1040400,-0.540504674; 1044000,-0.511513997;
        1047600,-0.436196642; 1051200,-0.323752929; 1054800,-0.184550738;
        1058400,-0.027807643; 1062000,0.138810415; 1065600,0.308550932;
        1069200,0.474473156; 1072800,0.627965928; 1076400,0.756893419;
        1080000,0.844457705; 1083600,0.872876752; 1087200,0.834722167;
        1090800,0.739755433; 1094400,0.606187916; 1098000,0.450168115;
        1101600,0.28318588; 1105200,0.113490388; 1108800,-0.052089885;
        1112400,-0.206727187; 1116000,-0.342547809; 1119600,-0.450098665;
        1123200,-0.524971501; 1126800,-0.540504674; 1130400,-0.511513997;
        1134000,-0.436196642; 1137600,-0.323752929; 1141200,-0.184550738;
        1144800,-0.027807643; 1148400,0.138810415; 1152000,0.308550932;
        1155600,0.474473156; 1159200,0.627965928; 1162800,0.756893419;
        1166400,0.844457705; 1170000,0.872876752; 1173600,0.834722167;
        1177200,0.739755433; 1180800,0.606187916; 1184400,0.450168115;
        1188000,0.28318588; 1191600,0.113490388; 1195200,-0.052089885;
        1198800,-0.206727187; 1202400,-0.342547809; 1206000,-0.450098665;
        1209600,-0.524971501; 1213200,-0.540504674; 1216800,-0.511513997;
        1220400,-0.436196642; 1224000,-0.323752929; 1227600,-0.184550738;
        1231200,-0.027807643; 1234800,0.138810415; 1238400,0.308550932;
        1242000,0.474473156; 1245600,0.627965928; 1249200,0.756893419;
        1252800,0.844457705; 1256400,0.872876752; 1260000,0.834722167;
        1263600,0.739755433; 1267200,0.606187916; 1270800,0.450168115;
        1274400,0.28318588; 1278000,0.113490388; 1281600,-0.052089885;
        1285200,-0.206727187; 1288800,-0.342547809; 1292400,-0.450098665;
        1296000,-0.524971501; 1299600,-0.540504674; 1303200,-0.511513997;
        1306800,-0.436196642; 1310400,-0.323752929; 1314000,-0.184550738;
        1317600,-0.027807643; 1321200,0.138810415; 1324800,0.308550932;
        1328400,0.474473156; 1332000,0.627965928; 1335600,0.756893419;
        1339200,0.844457705; 1342800,0.872876752; 1346400,0.834722167;
        1350000,0.739755433; 1353600,0.606187916; 1357200,0.450168115;
        1360800,0.28318588; 1364400,0.113490388; 1368000,-0.052089885;
        1371600,-0.206727187; 1375200,-0.342547809; 1378800,-0.450098665;
        1382400,-0.524971501; 1386000,-0.540504674; 1389600,-0.511513997;
        1393200,-0.436196642; 1396800,-0.323752929; 1400400,-0.184550738;
        1404000,-0.027807643; 1407600,0.138810415; 1411200,0.308550932;
        1414800,0.474473156; 1418400,0.627965928; 1422000,0.756893419;
        1425600,0.844457705; 1429200,0.872876752; 1432800,0.834722167;
        1436400,0.739755433; 1440000,0.606187916; 1443600,0.450168115;
        1447200,0.28318588; 1450800,0.113490388; 1454400,-0.052089885;
        1458000,-0.206727187; 1461600,-0.342547809; 1465200,-0.450098665;
        1468800,-0.524971501; 1472400,-0.540504674; 1476000,-0.511513997;
        1479600,-0.436196642; 1483200,-0.323752929; 1486800,-0.184550738;
        1490400,-0.027807643; 1494000,0.138810415; 1497600,0.308550932;
        1501200,0.474473156; 1504800,0.627965928; 1508400,0.756893419;
        1512000,0.844457705; 1515600,0.872876752; 1519200,0.834722167;
        1522800,0.739755433; 1526400,0.606187916; 1530000,0.450168115;
        1533600,0.28318588; 1537200,0.113490388; 1540800,-0.052089885;
        1544400,-0.206727187; 1548000,-0.342547809; 1551600,-0.450098665;
        1555200,-0.524971501; 1558800,-0.540504674; 1562400,-0.511513997;
        1566000,-0.436196642; 1569600,-0.323752929; 1573200,-0.184550738;
        1576800,-0.027807643; 1580400,0.138810415; 1584000,0.308550932;
        1587600,0.474473156; 1591200,0.627965928; 1594800,0.756893419;
        1598400,0.844457705; 1602000,0.872876752; 1605600,0.834722167;
        1609200,0.739755433; 1612800,0.606187916; 1616400,0.450168115;
        1620000,0.28318588; 1623600,0.113490388; 1627200,-0.052089885;
        1630800,-0.206727187; 1634400,-0.342547809; 1638000,-0.450098665])
    "Solar altitude angle"
    annotation (Placement(transformation(extent={{-96,-52},{-82,-38}})));
  Modelica.Blocks.Sources.CombiTimeTable HDifTilCle(
    columns={2},
    smoothness=Modelica.Blocks.Types.Smoothness.ConstantSegments,
    tableName="HDifTilCle",
    tableOnFile=false,
    table=[0,0; 3600,0; 7200,0; 10800,0; 14400,0; 18000,0; 21600,0; 25200,
        12.09644867; 28800,27.25095027; 32400,38.27385402; 36000,45.82451;
        39600,51.57958573; 43200,54.91750562; 46800,55.89716878; 50400,
        54.57011009; 54000,50.87097992; 57600,44.75882584; 61200,
        37.07302936; 64800,25.04319434; 68400,9.799046246; 72000,0; 75600,
        0; 79200,0; 82800,0; 86400,0; 90000,0; 93600,0; 97200,0; 100800,0;
        104400,0; 108000,0; 111600,12.09644867; 115200,27.25095027;
        118800,38.27385402; 122400,45.82451; 126000,51.57958573; 129600,
        54.91750562; 133200,55.89716878; 136800,54.57011009; 140400,
        50.87097992; 144000,44.75882584; 147600,37.07302936; 151200,
        25.04319434; 154800,9.799046246; 158400,0; 162000,0; 165600,0;
        169200,0; 172800,0; 176400,0; 180000,0; 183600,0; 187200,0;
        190800,0; 194400,0; 198000,12.09644867; 201600,27.25095027;
        205200,38.27385402; 208800,45.82451; 212400,51.57958573; 216000,
        54.91750562; 219600,55.89716878; 223200,54.57011009; 226800,
        50.87097992; 230400,44.75882584; 234000,37.07302936; 237600,
        25.04319434; 241200,9.799046246; 244800,0; 248400,0; 252000,0;
        255600,0; 259200,0; 262800,0; 266400,0; 270000,0; 273600,0;
        277200,0; 280800,0; 284400,12.09644867; 288000,27.25095027;
        291600,38.27385402; 295200,45.82451; 298800,51.57958573; 302400,
        54.91750562; 306000,55.89716878; 309600,54.57011009; 313200,
        50.87097992; 316800,44.75882584; 320400,37.07302936; 324000,
        25.04319434; 327600,9.799046246; 331200,0; 334800,0; 338400,0;
        342000,0; 345600,0; 349200,0; 352800,0; 356400,0; 360000,0;
        363600,0; 367200,0; 370800,12.09644867; 374400,27.25095027;
        378000,38.27385402; 381600,45.82451; 385200,51.57958573; 388800,
        54.91750562; 392400,55.89716878; 396000,54.57011009; 399600,
        50.87097992; 403200,44.75882584; 406800,37.07302936; 410400,
        25.04319434; 414000,9.799046246; 417600,0; 421200,0; 424800,0;
        428400,0; 432000,0; 435600,0; 439200,0; 442800,0; 446400,0;
        450000,0; 453600,0; 457200,12.09644867; 460800,27.25095027;
        464400,38.27385402; 468000,45.82451; 471600,51.57958573; 475200,
        54.91750562; 478800,55.89716878; 482400,54.57011009; 486000,
        50.87097992; 489600,44.75882584; 493200,37.07302936; 496800,
        25.04319434; 500400,9.799046246; 504000,0; 507600,0; 511200,0;
        514800,0; 518400,0; 522000,0; 525600,0; 529200,0; 532800,0;
        536400,0; 540000,0; 543600,12.09644867; 547200,27.25095027;
        550800,38.27385402; 554400,45.82451; 558000,51.57958573; 561600,
        54.91750562; 565200,55.89716878; 568800,54.57011009; 572400,
        50.87097992; 576000,44.75882584; 579600,37.07302936; 583200,
        25.04319434; 586800,9.799046246; 590400,0; 594000,0; 597600,0;
        601200,0; 604800,0; 608400,0; 612000,0; 615600,0; 619200,0;
        622800,0; 626400,0; 630000,12.09644867; 633600,27.25095027;
        637200,38.27385402; 640800,45.82451; 644400,51.57958573; 648000,
        54.91750562; 651600,55.89716878; 655200,54.57011009; 658800,
        50.87097992; 662400,44.75882584; 666000,37.07302936; 669600,
        25.04319434; 673200,9.799046246; 676800,0; 680400,0; 684000,0;
        687600,0; 691200,0; 694800,0; 698400,0; 702000,0; 705600,0;
        709200,0; 712800,0; 716400,12.09644867; 720000,27.25095027;
        723600,38.27385402; 727200,45.82451; 730800,51.57958573; 734400,
        54.91750562; 738000,55.89716878; 741600,54.57011009; 745200,
        50.87097992; 748800,44.75882584; 752400,37.07302936; 756000,
        25.04319434; 759600,9.799046246; 763200,0; 766800,0; 770400,0;
        774000,0; 777600,0; 781200,0; 784800,0; 788400,0; 792000,0;
        795600,0; 799200,0; 802800,12.09644867; 806400,27.25095027;
        810000,38.27385402; 813600,45.82451; 817200,51.57958573; 820800,
        54.91750562; 824400,55.89716878; 828000,54.57011009; 831600,
        50.87097992; 835200,44.75882584; 838800,37.07302936; 842400,
        25.04319434; 846000,9.799046246; 849600,0; 853200,0; 856800,0;
        860400,0; 864000,0; 867600,0; 871200,0; 874800,0; 878400,0;
        882000,0; 885600,0; 889200,12.09644867; 892800,27.25095027;
        896400,38.27385402; 900000,45.82451; 903600,51.57958573; 907200,
        54.91750562; 910800,55.89716878; 914400,54.57011009; 918000,
        50.87097992; 921600,44.75882584; 925200,37.07302936; 928800,
        25.04319434; 932400,9.799046246; 936000,0; 939600,0; 943200,0;
        946800,0; 950400,0; 954000,0; 957600,0; 961200,0; 964800,0;
        968400,0; 972000,0; 975600,12.09644867; 979200,27.25095027;
        982800,38.27385402; 986400,45.82451; 990000,51.57958573; 993600,
        54.91750562; 997200,55.89716878; 1000800,54.57011009; 1004400,
        50.87097992; 1008000,44.75882584; 1011600,37.07302936; 1015200,
        25.04319434; 1018800,9.799046246; 1022400,0; 1026000,0; 1029600,0;
        1033200,0; 1036800,0; 1040400,0; 1044000,0; 1047600,0; 1051200,0;
        1054800,0; 1058400,0; 1062000,12.09644867; 1065600,27.25095027;
        1069200,38.27385402; 1072800,45.82451; 1076400,51.57958573;
        1080000,54.91750562; 1083600,55.89716878; 1087200,54.57011009;
        1090800,50.87097992; 1094400,44.75882584; 1098000,37.07302936;
        1101600,25.04319434; 1105200,9.799046246; 1108800,0; 1112400,0;
        1116000,0; 1119600,0; 1123200,0; 1126800,0; 1130400,0; 1134000,0;
        1137600,0; 1141200,0; 1144800,0; 1148400,12.09644867; 1152000,
        27.25095027; 1155600,38.27385402; 1159200,45.82451; 1162800,
        51.57958573; 1166400,54.91750562; 1170000,55.89716878; 1173600,
        54.57011009; 1177200,50.87097992; 1180800,44.75882584; 1184400,
        37.07302936; 1188000,25.04319434; 1191600,9.799046246; 1195200,0;
        1198800,0; 1202400,0; 1206000,0; 1209600,0; 1213200,0; 1216800,0;
        1220400,0; 1224000,0; 1227600,0; 1231200,0; 1234800,23.26734519;
        1238400,47.10145092; 1242000,63.56086174; 1245600,75.24935853;
        1249200,84.63765841; 1252800,90.25746571; 1256400,91.93142037;
        1260000,89.6665522; 1263600,83.46122296; 1267200,73.55208829;
        1270800,61.78366585; 1274400,43.73975719; 1278000,19.33526916;
        1281600,0; 1285200,0; 1288800,0; 1292400,0; 1296000,0; 1299600,0;
        1303200,0; 1306800,0; 1310400,0; 1314000,0; 1317600,0; 1321200,
        23.26734519; 1324800,47.10145092; 1328400,63.56086174; 1332000,
        75.24935853; 1335600,84.63765841; 1339200,90.25746571; 1342800,
        91.93142037; 1346400,89.6665522; 1350000,83.46122296; 1353600,
        73.55208829; 1357200,61.78366585; 1360800,43.73975719; 1364400,
        19.33526916; 1368000,0; 1371600,0; 1375200,0; 1378800,0; 1382400,
        0; 1386000,0; 1389600,0; 1393200,0; 1396800,0; 1400400,0; 1404000,
        0; 1407600,23.26734519; 1411200,47.10145092; 1414800,63.56086174;
        1418400,75.24935853; 1422000,84.63765841; 1425600,90.25746571;
        1429200,91.93142037; 1432800,89.6665522; 1436400,83.46122296;
        1440000,73.55208829; 1443600,61.78366585; 1447200,43.73975719;
        1450800,19.33526916; 1454400,0; 1458000,0; 1461600,0; 1465200,0;
        1468800,0; 1472400,0; 1476000,0; 1479600,0; 1483200,0; 1486800,0;
        1490400,0; 1494000,23.26734519; 1497600,47.10145092; 1501200,
        63.56086174; 1504800,75.24935853; 1508400,84.63765841; 1512000,
        90.25746571; 1515600,91.93142037; 1519200,89.6665522; 1522800,
        83.46122296; 1526400,73.55208829; 1530000,61.78366585; 1533600,
        43.73975719; 1537200,19.33526916; 1540800,0; 1544400,0; 1548000,0;
        1551600,0; 1555200,0; 1558800,0; 1562400,0; 1566000,0; 1569600,0;
        1573200,0; 1576800,0; 1580400,23.26734519; 1584000,47.10145092;
        1587600,63.56086174; 1591200,75.24935853; 1594800,84.63765841;
        1598400,90.25746571; 1602000,91.93142037; 1605600,89.6665522;
        1609200,83.46122296; 1612800,73.55208829; 1616400,61.78366585;
        1620000,43.73975719; 1623600,19.33526916; 1627200,0; 1630800,0;
        1634400,0; 1638000,0])
    "Diffuse irradiation on tilted surface at clear sky"
    annotation (Placement(transformation(extent={{-96,16},{-82,30}})));
  Modelica.Blocks.Sources.CombiTimeTable HDifTilCov(
    columns={2},
    smoothness=Modelica.Blocks.Types.Smoothness.ConstantSegments,
    tableName="HDifTilCov",
    tableOnFile=false,
    table=[0,0; 3600,0; 7200,0; 10800,0; 14400,0; 18000,0; 21600,0; 25200,
        9.603148499; 28800,27.44337611; 32400,48.23236103; 36000,
        67.90455038; 39600,83.61332758; 43200,93.50445335; 46800,
        96.54693507; 50400,92.4422546; 54000,81.59516725; 57600,
        65.15276159; 61200,45.10461005; 64800,24.46735599; 68400,
        7.478626154; 72000,0; 75600,0; 79200,0; 82800,0; 86400,0; 90000,0;
        93600,0; 97200,0; 100800,0; 104400,0; 108000,0; 111600,
        9.603148499; 115200,27.44337611; 118800,48.23236103; 122400,
        67.90455038; 126000,83.61332758; 129600,93.50445335; 133200,
        96.54693507; 136800,92.4422546; 140400,81.59516725; 144000,
        65.15276159; 147600,45.10461005; 151200,24.46735599; 154800,
        7.478626154; 158400,0; 162000,0; 165600,0; 169200,0; 172800,0;
        176400,0; 180000,0; 183600,0; 187200,0; 190800,0; 194400,0;
        198000,9.603148499; 201600,27.44337611; 205200,48.23236103;
        208800,67.90455038; 212400,83.61332758; 216000,93.50445335;
        219600,96.54693507; 223200,92.4422546; 226800,81.59516725; 230400,
        65.15276159; 234000,45.10461005; 237600,24.46735599; 241200,
        7.478626154; 244800,0; 248400,0; 252000,0; 255600,0; 259200,0;
        262800,0; 266400,0; 270000,0; 273600,0; 277200,0; 280800,0;
        284400,9.603148499; 288000,27.44337611; 291600,48.23236103;
        295200,67.90455038; 298800,83.61332758; 302400,93.50445335;
        306000,96.54693507; 309600,92.4422546; 313200,81.59516725; 316800,
        65.15276159; 320400,45.10461005; 324000,24.46735599; 327600,
        7.478626154; 331200,0; 334800,0; 338400,0; 342000,0; 345600,0;
        349200,0; 352800,0; 356400,0; 360000,0; 363600,0; 367200,0;
        370800,9.603148499; 374400,27.44337611; 378000,48.23236103;
        381600,67.90455038; 385200,83.61332758; 388800,93.50445335;
        392400,96.54693507; 396000,92.4422546; 399600,81.59516725; 403200,
        65.15276159; 406800,45.10461005; 410400,24.46735599; 414000,
        7.478626154; 417600,0; 421200,0; 424800,0; 428400,0; 432000,0;
        435600,0; 439200,0; 442800,0; 446400,0; 450000,0; 453600,0;
        457200,9.603148499; 460800,27.44337611; 464400,48.23236103;
        468000,67.90455038; 471600,83.61332758; 475200,93.50445335;
        478800,96.54693507; 482400,92.4422546; 486000,81.59516725; 489600,
        65.15276159; 493200,45.10461005; 496800,24.46735599; 500400,
        7.478626154; 504000,0; 507600,0; 511200,0; 514800,0; 518400,0;
        522000,0; 525600,0; 529200,0; 532800,0; 536400,0; 540000,0;
        543600,9.603148499; 547200,27.44337611; 550800,48.23236103;
        554400,67.90455038; 558000,83.61332758; 561600,93.50445335;
        565200,96.54693507; 568800,92.4422546; 572400,81.59516725; 576000,
        65.15276159; 579600,45.10461005; 583200,24.46735599; 586800,
        7.478626154; 590400,0; 594000,0; 597600,0; 601200,0; 604800,0;
        608400,0; 612000,0; 615600,0; 619200,0; 622800,0; 626400,0;
        630000,9.603148499; 633600,27.44337611; 637200,48.23236103;
        640800,67.90455038; 644400,83.61332758; 648000,93.50445335;
        651600,96.54693507; 655200,92.4422546; 658800,81.59516725; 662400,
        65.15276159; 666000,45.10461005; 669600,24.46735599; 673200,
        7.478626154; 676800,0; 680400,0; 684000,0; 687600,0; 691200,0;
        694800,0; 698400,0; 702000,0; 705600,0; 709200,0; 712800,0;
        716400,9.603148499; 720000,27.44337611; 723600,48.23236103;
        727200,67.90455038; 730800,83.61332758; 734400,93.50445335;
        738000,96.54693507; 741600,92.4422546; 745200,81.59516725; 748800,
        65.15276159; 752400,45.10461005; 756000,24.46735599; 759600,
        7.478626154; 763200,0; 766800,0; 770400,0; 774000,0; 777600,0;
        781200,0; 784800,0; 788400,0; 792000,0; 795600,0; 799200,0;
        802800,9.603148499; 806400,27.44337611; 810000,48.23236103;
        813600,67.90455038; 817200,83.61332758; 820800,93.50445335;
        824400,96.54693507; 828000,92.4422546; 831600,81.59516725; 835200,
        65.15276159; 838800,45.10461005; 842400,24.46735599; 846000,
        7.478626154; 849600,0; 853200,0; 856800,0; 860400,0; 864000,0;
        867600,0; 871200,0; 874800,0; 878400,0; 882000,0; 885600,0;
        889200,9.603148499; 892800,27.44337611; 896400,48.23236103;
        900000,67.90455038; 903600,83.61332758; 907200,93.50445335;
        910800,96.54693507; 914400,92.4422546; 918000,81.59516725; 921600,
        65.15276159; 925200,45.10461005; 928800,24.46735599; 932400,
        7.478626154; 936000,0; 939600,0; 943200,0; 946800,0; 950400,0;
        954000,0; 957600,0; 961200,0; 964800,0; 968400,0; 972000,0;
        975600,9.603148499; 979200,27.44337611; 982800,48.23236103;
        986400,67.90455038; 990000,83.61332758; 993600,93.50445335;
        997200,96.54693507; 1000800,92.4422546; 1004400,81.59516725;
        1008000,65.15276159; 1011600,45.10461005; 1015200,24.46735599;
        1018800,7.478626154; 1022400,0; 1026000,0; 1029600,0; 1033200,0;
        1036800,0; 1040400,0; 1044000,0; 1047600,0; 1051200,0; 1054800,0;
        1058400,0; 1062000,9.603148499; 1065600,27.44337611; 1069200,
        48.23236103; 1072800,67.90455038; 1076400,83.61332758; 1080000,
        93.50445335; 1083600,96.54693507; 1087200,92.4422546; 1090800,
        81.59516725; 1094400,65.15276159; 1098000,45.10461005; 1101600,
        24.46735599; 1105200,7.478626154; 1108800,0; 1112400,0; 1116000,0;
        1119600,0; 1123200,0; 1126800,0; 1130400,0; 1134000,0; 1137600,0;
        1141200,0; 1144800,0; 1148400,9.603148499; 1152000,27.44337611;
        1155600,48.23236103; 1159200,67.90455038; 1162800,83.61332758;
        1166400,93.50445335; 1170000,96.54693507; 1173600,92.4422546;
        1177200,81.59516725; 1180800,65.15276159; 1184400,45.10461005;
        1188000,24.46735599; 1191600,7.478626154; 1195200,0; 1198800,0;
        1202400,0; 1206000,0; 1209600,0; 1213200,0; 1216800,0; 1220400,0;
        1224000,0; 1227600,0; 1231200,0; 1234800,2.32324972; 1238400,
        6.600661871; 1242000,11.36216174; 1245600,15.75510219; 1249200,
        19.21671663; 1252800,21.38153013; 1256400,22.04553048; 1260000,
        21.14951495; 1263600,18.7737413; 1267200,15.14507191; 1270800,
        10.65548364; 1274400,5.90307651; 1278000,1.797616109; 1281600,0;
        1285200,0; 1288800,0; 1292400,0; 1296000,0; 1299600,0; 1303200,0;
        1306800,0; 1310400,0; 1314000,0; 1317600,0; 1321200,2.32324972;
        1324800,6.600661871; 1328400,11.36216174; 1332000,15.75510219;
        1335600,19.21671663; 1339200,21.38153013; 1342800,22.04553048;
        1346400,21.14951495; 1350000,18.7737413; 1353600,15.14507191;
        1357200,10.65548364; 1360800,5.90307651; 1364400,1.797616109;
        1368000,0; 1371600,0; 1375200,0; 1378800,0; 1382400,0; 1386000,0;
        1389600,0; 1393200,0; 1396800,0; 1400400,0; 1404000,0; 1407600,
        2.32324972; 1411200,6.600661871; 1414800,11.36216174; 1418400,
        15.75510219; 1422000,19.21671663; 1425600,21.38153013; 1429200,
        22.04553048; 1432800,21.14951495; 1436400,18.7737413; 1440000,
        15.14507191; 1443600,10.65548364; 1447200,5.90307651; 1450800,
        1.797616109; 1454400,0; 1458000,0; 1461600,0; 1465200,0; 1468800,
        0; 1472400,0; 1476000,0; 1479600,0; 1483200,0; 1486800,0; 1490400,
        0; 1494000,2.32324972; 1497600,6.600661871; 1501200,11.36216174;
        1504800,15.75510219; 1508400,19.21671663; 1512000,21.38153013;
        1515600,22.04553048; 1519200,21.14951495; 1522800,18.7737413;
        1526400,15.14507191; 1530000,10.65548364; 1533600,5.90307651;
        1537200,1.797616109; 1540800,0; 1544400,0; 1548000,0; 1551600,0;
        1555200,0; 1558800,0; 1562400,0; 1566000,0; 1569600,0; 1573200,0;
        1576800,0; 1580400,2.32324972; 1584000,6.600661871; 1587600,
        11.36216174; 1591200,15.75510219; 1594800,19.21671663; 1598400,
        21.38153013; 1602000,22.04553048; 1605600,21.14951495; 1609200,
        18.7737413; 1612800,15.14507191; 1616400,10.65548364; 1620000,
        5.90307651; 1623600,1.797616109; 1627200,0; 1630800,0; 1634400,0;
        1638000,0]) "Diffuse irradiation on tilted surface"
    annotation (Placement(transformation(extent={{-96,-6},{-82,8}})));
  Modelica.Blocks.Math.Add HDifTil
    "Diffuse irradiation on a tilted surface"
    annotation (Placement(transformation(extent={{-32,8},{-22,18}})));
  Modelica.Blocks.Sources.CombiTimeTable HDifHorCov(
    columns={2},
    smoothness=Modelica.Blocks.Types.Smoothness.ConstantSegments,
    tableName="HDifHorCov",
    tableOnFile=false,
    table=[0,0; 3600,0; 7200,0; 10800,0; 14400,0; 18000,0; 21600,0; 25200,
        24.22614885; 28800,69.2322226; 32400,121.6772143; 36000,
        171.3048325; 39600,210.9338328; 43200,235.8864705; 46800,
        243.5618298; 50400,233.20683; 54000,205.8425596; 57600,
        164.3628129; 61200,113.7867437; 64800,61.72452797; 68400,
        18.86655303; 72000,0; 75600,0; 79200,0; 82800,0; 86400,0; 90000,0;
        93600,0; 97200,0; 100800,0; 104400,0; 108000,0; 111600,
        24.22614885; 115200,69.2322226; 118800,121.6772143; 122400,
        171.3048325; 126000,210.9338328; 129600,235.8864705; 133200,
        243.5618298; 136800,233.20683; 140400,205.8425596; 144000,
        164.3628129; 147600,113.7867437; 151200,61.72452797; 154800,
        18.86655303; 158400,0; 162000,0; 165600,0; 169200,0; 172800,0;
        176400,0; 180000,0; 183600,0; 187200,0; 190800,0; 194400,0;
        198000,24.22614885; 201600,69.2322226; 205200,121.6772143; 208800,
        171.3048325; 212400,210.9338328; 216000,235.8864705; 219600,
        243.5618298; 223200,233.20683; 226800,205.8425596; 230400,
        164.3628129; 234000,113.7867437; 237600,61.72452797; 241200,
        18.86655303; 244800,0; 248400,0; 252000,0; 255600,0; 259200,0;
        262800,0; 266400,0; 270000,0; 273600,0; 277200,0; 280800,0;
        284400,24.22614885; 288000,69.2322226; 291600,121.6772143; 295200,
        171.3048325; 298800,210.9338328; 302400,235.8864705; 306000,
        243.5618298; 309600,233.20683; 313200,205.8425596; 316800,
        164.3628129; 320400,113.7867437; 324000,61.72452797; 327600,
        18.86655303; 331200,0; 334800,0; 338400,0; 342000,0; 345600,0;
        349200,0; 352800,0; 356400,0; 360000,0; 363600,0; 367200,0;
        370800,24.22614885; 374400,69.2322226; 378000,121.6772143; 381600,
        171.3048325; 385200,210.9338328; 388800,235.8864705; 392400,
        243.5618298; 396000,233.20683; 399600,205.8425596; 403200,
        164.3628129; 406800,113.7867437; 410400,61.72452797; 414000,
        18.86655303; 417600,0; 421200,0; 424800,0; 428400,0; 432000,0;
        435600,0; 439200,0; 442800,0; 446400,0; 450000,0; 453600,0;
        457200,24.22614885; 460800,69.2322226; 464400,121.6772143; 468000,
        171.3048325; 471600,210.9338328; 475200,235.8864705; 478800,
        243.5618298; 482400,233.20683; 486000,205.8425596; 489600,
        164.3628129; 493200,113.7867437; 496800,61.72452797; 500400,
        18.86655303; 504000,0; 507600,0; 511200,0; 514800,0; 518400,0;
        522000,0; 525600,0; 529200,0; 532800,0; 536400,0; 540000,0;
        543600,24.22614885; 547200,69.2322226; 550800,121.6772143; 554400,
        171.3048325; 558000,210.9338328; 561600,235.8864705; 565200,
        243.5618298; 568800,233.20683; 572400,205.8425596; 576000,
        164.3628129; 579600,113.7867437; 583200,61.72452797; 586800,
        18.86655303; 590400,0; 594000,0; 597600,0; 601200,0; 604800,0;
        608400,0; 612000,0; 615600,0; 619200,0; 622800,0; 626400,0;
        630000,24.22614885; 633600,69.2322226; 637200,121.6772143; 640800,
        171.3048325; 644400,210.9338328; 648000,235.8864705; 651600,
        243.5618298; 655200,233.20683; 658800,205.8425596; 662400,
        164.3628129; 666000,113.7867437; 669600,61.72452797; 673200,
        18.86655303; 676800,0; 680400,0; 684000,0; 687600,0; 691200,0;
        694800,0; 698400,0; 702000,0; 705600,0; 709200,0; 712800,0;
        716400,24.22614885; 720000,69.2322226; 723600,121.6772143; 727200,
        171.3048325; 730800,210.9338328; 734400,235.8864705; 738000,
        243.5618298; 741600,233.20683; 745200,205.8425596; 748800,
        164.3628129; 752400,113.7867437; 756000,61.72452797; 759600,
        18.86655303; 763200,0; 766800,0; 770400,0; 774000,0; 777600,0;
        781200,0; 784800,0; 788400,0; 792000,0; 795600,0; 799200,0;
        802800,24.22614885; 806400,69.2322226; 810000,121.6772143; 813600,
        171.3048325; 817200,210.9338328; 820800,235.8864705; 824400,
        243.5618298; 828000,233.20683; 831600,205.8425596; 835200,
        164.3628129; 838800,113.7867437; 842400,61.72452797; 846000,
        18.86655303; 849600,0; 853200,0; 856800,0; 860400,0; 864000,0;
        867600,0; 871200,0; 874800,0; 878400,0; 882000,0; 885600,0;
        889200,24.22614885; 892800,69.2322226; 896400,121.6772143; 900000,
        171.3048325; 903600,210.9338328; 907200,235.8864705; 910800,
        243.5618298; 914400,233.20683; 918000,205.8425596; 921600,
        164.3628129; 925200,113.7867437; 928800,61.72452797; 932400,
        18.86655303; 936000,0; 939600,0; 943200,0; 946800,0; 950400,0;
        954000,0; 957600,0; 961200,0; 964800,0; 968400,0; 972000,0;
        975600,24.22614885; 979200,69.2322226; 982800,121.6772143; 986400,
        171.3048325; 990000,210.9338328; 993600,235.8864705; 997200,
        243.5618298; 1000800,233.20683; 1004400,205.8425596; 1008000,
        164.3628129; 1011600,113.7867437; 1015200,61.72452797; 1018800,
        18.86655303; 1022400,0; 1026000,0; 1029600,0; 1033200,0; 1036800,
        0; 1040400,0; 1044000,0; 1047600,0; 1051200,0; 1054800,0; 1058400,
        0; 1062000,24.22614885; 1065600,69.2322226; 1069200,121.6772143;
        1072800,171.3048325; 1076400,210.9338328; 1080000,235.8864705;
        1083600,243.5618298; 1087200,233.20683; 1090800,205.8425596;
        1094400,164.3628129; 1098000,113.7867437; 1101600,61.72452797;
        1105200,18.86655303; 1108800,0; 1112400,0; 1116000,0; 1119600,0;
        1123200,0; 1126800,0; 1130400,0; 1134000,0; 1137600,0; 1141200,0;
        1144800,0; 1148400,24.22614885; 1152000,69.2322226; 1155600,
        121.6772143; 1159200,171.3048325; 1162800,210.9338328; 1166400,
        235.8864705; 1170000,243.5618298; 1173600,233.20683; 1177200,
        205.8425596; 1180800,164.3628129; 1184400,113.7867437; 1188000,
        61.72452797; 1191600,18.86655303; 1195200,0; 1198800,0; 1202400,0;
        1206000,0; 1209600,0; 1213200,0; 1216800,0; 1220400,0; 1224000,0;
        1227600,0; 1231200,0; 1234800,5.860931292; 1238400,16.65168637;
        1242000,28.66366397; 1245600,39.74586572; 1249200,48.47858361;
        1252800,53.93982313; 1256400,55.6149166; 1260000,53.35451152;
        1263600,47.36107656; 1267200,38.20692416; 1270800,26.88090607;
        1274400,14.891867; 1278000,4.534899719; 1281600,0; 1285200,0;
        1288800,0; 1292400,0; 1296000,0; 1299600,0; 1303200,0; 1306800,0;
        1310400,0; 1314000,0; 1317600,0; 1321200,5.860931292; 1324800,
        16.65168637; 1328400,28.66366397; 1332000,39.74586572; 1335600,
        48.47858361; 1339200,53.93982313; 1342800,55.6149166; 1346400,
        53.35451152; 1350000,47.36107656; 1353600,38.20692416; 1357200,
        26.88090607; 1360800,14.891867; 1364400,4.534899719; 1368000,0;
        1371600,0; 1375200,0; 1378800,0; 1382400,0; 1386000,0; 1389600,0;
        1393200,0; 1396800,0; 1400400,0; 1404000,0; 1407600,5.860931292;
        1411200,16.65168637; 1414800,28.66366397; 1418400,39.74586572;
        1422000,48.47858361; 1425600,53.93982313; 1429200,55.6149166;
        1432800,53.35451152; 1436400,47.36107656; 1440000,38.20692416;
        1443600,26.88090607; 1447200,14.891867; 1450800,4.534899719;
        1454400,0; 1458000,0; 1461600,0; 1465200,0; 1468800,0; 1472400,0;
        1476000,0; 1479600,0; 1483200,0; 1486800,0; 1490400,0; 1494000,
        5.860931292; 1497600,16.65168637; 1501200,28.66366397; 1504800,
        39.74586572; 1508400,48.47858361; 1512000,53.93982313; 1515600,
        55.6149166; 1519200,53.35451152; 1522800,47.36107656; 1526400,
        38.20692416; 1530000,26.88090607; 1533600,14.891867; 1537200,
        4.534899719; 1540800,0; 1544400,0; 1548000,0; 1551600,0; 1555200,
        0; 1558800,0; 1562400,0; 1566000,0; 1569600,0; 1573200,0; 1576800,
        0; 1580400,5.860931292; 1584000,16.65168637; 1587600,28.66366397;
        1591200,39.74586572; 1594800,48.47858361; 1598400,53.93982313;
        1602000,55.6149166; 1605600,53.35451152; 1609200,47.36107656;
        1612800,38.20692416; 1616400,26.88090607; 1620000,14.891867;
        1623600,4.534899719; 1627200,0; 1630800,0; 1634400,0; 1638000,0])
    "Diffuse irradiation on a horizontal surface at covered sky"
    annotation (Placement(transformation(extent={{-96,56},{-82,70}})));
  Modelica.Blocks.Math.Add HDifHor
    "Diffuse irradiation on a horizontal surface"
    annotation (Placement(transformation(extent={{-32,32},{-22,42}})));
  Modelica.Blocks.Sources.CombiTimeTable HDifHorCle(
    columns={2},
    smoothness=Modelica.Blocks.Types.Smoothness.ConstantSegments,
    tableName="HDifHorCle",
    tableOnFile=false,
    table=[0,0; 3600,0; 7200,0; 10800,0; 14400,0; 18000,0; 21600,0; 25200,
        21.04231965; 28800,38.76402419; 32400,49.79122826; 36000,
        56.90519903; 39600,61.37224652; 43200,63.79161511; 46800,
        64.48257797; 50400,63.54466077; 54000,60.84410045; 57600,
        56.02824899; 61200,48.43452029; 64800,36.62912553; 68400,
        17.58508841; 72000,0; 75600,0; 79200,0; 82800,0; 86400,0; 90000,0;
        93600,0; 97200,0; 100800,0; 104400,0; 108000,0; 111600,
        21.04231965; 115200,38.76402419; 118800,49.79122826; 122400,
        56.90519903; 126000,61.37224652; 129600,63.79161511; 133200,
        64.48257797; 136800,63.54466077; 140400,60.84410045; 144000,
        56.02824899; 147600,48.43452029; 151200,36.62912553; 154800,
        17.58508841; 158400,0; 162000,0; 165600,0; 169200,0; 172800,0;
        176400,0; 180000,0; 183600,0; 187200,0; 190800,0; 194400,0;
        198000,21.04231965; 201600,38.76402419; 205200,49.79122826;
        208800,56.90519903; 212400,61.37224652; 216000,63.79161511;
        219600,64.48257797; 223200,63.54466077; 226800,60.84410045;
        230400,56.02824899; 234000,48.43452029; 237600,36.62912553;
        241200,17.58508841; 244800,0; 248400,0; 252000,0; 255600,0;
        259200,0; 262800,0; 266400,0; 270000,0; 273600,0; 277200,0;
        280800,0; 284400,21.04231965; 288000,38.76402419; 291600,
        49.79122826; 295200,56.90519903; 298800,61.37224652; 302400,
        63.79161511; 306000,64.48257797; 309600,63.54466077; 313200,
        60.84410045; 316800,56.02824899; 320400,48.43452029; 324000,
        36.62912553; 327600,17.58508841; 331200,0; 334800,0; 338400,0;
        342000,0; 345600,0; 349200,0; 352800,0; 356400,0; 360000,0;
        363600,0; 367200,0; 370800,21.04231965; 374400,38.76402419;
        378000,49.79122826; 381600,56.90519903; 385200,61.37224652;
        388800,63.79161511; 392400,64.48257797; 396000,63.54466077;
        399600,60.84410045; 403200,56.02824899; 406800,48.43452029;
        410400,36.62912553; 414000,17.58508841; 417600,0; 421200,0;
        424800,0; 428400,0; 432000,0; 435600,0; 439200,0; 442800,0;
        446400,0; 450000,0; 453600,0; 457200,21.04231965; 460800,
        38.76402419; 464400,49.79122826; 468000,56.90519903; 471600,
        61.37224652; 475200,63.79161511; 478800,64.48257797; 482400,
        63.54466077; 486000,60.84410045; 489600,56.02824899; 493200,
        48.43452029; 496800,36.62912553; 500400,17.58508841; 504000,0;
        507600,0; 511200,0; 514800,0; 518400,0; 522000,0; 525600,0;
        529200,0; 532800,0; 536400,0; 540000,0; 543600,21.04231965;
        547200,38.76402419; 550800,49.79122826; 554400,56.90519903;
        558000,61.37224652; 561600,63.79161511; 565200,64.48257797;
        568800,63.54466077; 572400,60.84410045; 576000,56.02824899;
        579600,48.43452029; 583200,36.62912553; 586800,17.58508841;
        590400,0; 594000,0; 597600,0; 601200,0; 604800,0; 608400,0;
        612000,0; 615600,0; 619200,0; 622800,0; 626400,0; 630000,
        21.04231965; 633600,38.76402419; 637200,49.79122826; 640800,
        56.90519903; 644400,61.37224652; 648000,63.79161511; 651600,
        64.48257797; 655200,63.54466077; 658800,60.84410045; 662400,
        56.02824899; 666000,48.43452029; 669600,36.62912553; 673200,
        17.58508841; 676800,0; 680400,0; 684000,0; 687600,0; 691200,0;
        694800,0; 698400,0; 702000,0; 705600,0; 709200,0; 712800,0;
        716400,21.04231965; 720000,38.76402419; 723600,49.79122826;
        727200,56.90519903; 730800,61.37224652; 734400,63.79161511;
        738000,64.48257797; 741600,63.54466077; 745200,60.84410045;
        748800,56.02824899; 752400,48.43452029; 756000,36.62912553;
        759600,17.58508841; 763200,0; 766800,0; 770400,0; 774000,0;
        777600,0; 781200,0; 784800,0; 788400,0; 792000,0; 795600,0;
        799200,0; 802800,21.04231965; 806400,38.76402419; 810000,
        49.79122826; 813600,56.90519903; 817200,61.37224652; 820800,
        63.79161511; 824400,64.48257797; 828000,63.54466077; 831600,
        60.84410045; 835200,56.02824899; 838800,48.43452029; 842400,
        36.62912553; 846000,17.58508841; 849600,0; 853200,0; 856800,0;
        860400,0; 864000,0; 867600,0; 871200,0; 874800,0; 878400,0;
        882000,0; 885600,0; 889200,21.04231965; 892800,38.76402419;
        896400,49.79122826; 900000,56.90519903; 903600,61.37224652;
        907200,63.79161511; 910800,64.48257797; 914400,63.54466077;
        918000,60.84410045; 921600,56.02824899; 925200,48.43452029;
        928800,36.62912553; 932400,17.58508841; 936000,0; 939600,0;
        943200,0; 946800,0; 950400,0; 954000,0; 957600,0; 961200,0;
        964800,0; 968400,0; 972000,0; 975600,21.04231965; 979200,
        38.76402419; 982800,49.79122826; 986400,56.90519903; 990000,
        61.37224652; 993600,63.79161511; 997200,64.48257797; 1000800,
        63.54466077; 1004400,60.84410045; 1008000,56.02824899; 1011600,
        48.43452029; 1015200,36.62912553; 1018800,17.58508841; 1022400,0;
        1026000,0; 1029600,0; 1033200,0; 1036800,0; 1040400,0; 1044000,0;
        1047600,0; 1051200,0; 1054800,0; 1058400,0; 1062000,21.04231965;
        1065600,38.76402419; 1069200,49.79122826; 1072800,56.90519903;
        1076400,61.37224652; 1080000,63.79161511; 1083600,64.48257797;
        1087200,63.54466077; 1090800,60.84410045; 1094400,56.02824899;
        1098000,48.43452029; 1101600,36.62912553; 1105200,17.58508841;
        1108800,0; 1112400,0; 1116000,0; 1119600,0; 1123200,0; 1126800,0;
        1130400,0; 1134000,0; 1137600,0; 1141200,0; 1144800,0; 1148400,
        21.04231965; 1152000,38.76402419; 1155600,49.79122826; 1159200,
        56.90519903; 1162800,61.37224652; 1166400,63.79161511; 1170000,
        64.48257797; 1173600,63.54466077; 1177200,60.84410045; 1180800,
        56.02824899; 1184400,48.43452029; 1188000,36.62912553; 1191600,
        17.58508841; 1195200,0; 1198800,0; 1202400,0; 1206000,0; 1209600,
        0; 1213200,0; 1216800,0; 1220400,0; 1224000,0; 1227600,0; 1231200,
        0; 1234800,40.47459946; 1238400,67.00103172; 1242000,82.68760638;
        1245600,93.44518302; 1249200,100.7065715; 1252800,104.8421528;
        1256400,106.0514354; 1260000,104.4130318; 1263600,99.82357411;
        1267200,92.07110863; 1270800,80.71803866; 1274400,63.97542723;
        1278000,34.69852159; 1281600,0; 1285200,0; 1288800,0; 1292400,0;
        1296000,0; 1299600,0; 1303200,0; 1306800,0; 1310400,0; 1314000,0;
        1317600,0; 1321200,40.47459946; 1324800,67.00103172; 1328400,
        82.68760638; 1332000,93.44518302; 1335600,100.7065715; 1339200,
        104.8421528; 1342800,106.0514354; 1346400,104.4130318; 1350000,
        99.82357411; 1353600,92.07110863; 1357200,80.71803866; 1360800,
        63.97542723; 1364400,34.69852159; 1368000,0; 1371600,0; 1375200,0;
        1378800,0; 1382400,0; 1386000,0; 1389600,0; 1393200,0; 1396800,0;
        1400400,0; 1404000,0; 1407600,40.47459946; 1411200,67.00103172;
        1414800,82.68760638; 1418400,93.44518302; 1422000,100.7065715;
        1425600,104.8421528; 1429200,106.0514354; 1432800,104.4130318;
        1436400,99.82357411; 1440000,92.07110863; 1443600,80.71803866;
        1447200,63.97542723; 1450800,34.69852159; 1454400,0; 1458000,0;
        1461600,0; 1465200,0; 1468800,0; 1472400,0; 1476000,0; 1479600,0;
        1483200,0; 1486800,0; 1490400,0; 1494000,40.47459946; 1497600,
        67.00103172; 1501200,82.68760638; 1504800,93.44518302; 1508400,
        100.7065715; 1512000,104.8421528; 1515600,106.0514354; 1519200,
        104.4130318; 1522800,99.82357411; 1526400,92.07110863; 1530000,
        80.71803866; 1533600,63.97542723; 1537200,34.69852159; 1540800,0;
        1544400,0; 1548000,0; 1551600,0; 1555200,0; 1558800,0; 1562400,0;
        1566000,0; 1569600,0; 1573200,0; 1576800,0; 1580400,40.47459946;
        1584000,67.00103172; 1587600,82.68760638; 1591200,93.44518302;
        1594800,100.7065715; 1598400,104.8421528; 1602000,106.0514354;
        1605600,104.4130318; 1609200,99.82357411; 1612800,92.07110863;
        1616400,80.71803866; 1620000,63.97542723; 1623600,34.69852159;
        1627200,0; 1630800,0; 1634400,0; 1638000,0])
    "Diffuse irradiation on a horizontal surface at clear sky"
    annotation (Placement(transformation(extent={{-96,36},{-82,50}})));
  AixLib.BoundaryConditions.SolarGeometry.BaseClasses.IncidenceAngle
    incAng(
    azi(displayUnit="deg") = 0,
    til(displayUnit="deg") = 1.5707963267949,
    lat=0.86393797973719) "Incidence angle for the window"
    annotation (Placement(transformation(extent={{-56,-40},{-44,-28}})));
  AixLib.BoundaryConditions.SolarIrradiation.BaseClasses.DirectTiltedSurface
    HDirTil "Direct solar irradiation on the window"
    annotation (Placement(transformation(extent={{-30,-26},{-14,-10}})));
  AixLib.ThermalZones.ReducedOrder.Windows.BaseClasses.Conversions.to_HDirNor to_HDirNor
    "Converts the direct irradiation onto a horizontal surface to direct
    irradiation on a normal surface"
    annotation (Placement(transformation(extent={{-58,-8},{-46,4}})));
  AixLib.ThermalZones.ReducedOrder.Windows.Validation.BaseClasses.SolarHourAngleVDI6007 SolHouAng(
    lon(displayUnit="deg") = 0.15009831567151)
    "Solar hour angle based on calculation of VDI 6007"
    annotation (Placement(transformation(extent={{-64,-40},{-58,-34}})));
  AixLib.ThermalZones.ReducedOrder.Windows.Validation.BaseClasses.SolarDeclinationAngleVDI6007 decAng
    "Declination angle  based on the calculations of VDI6007"
    annotation (Placement(transformation(extent={{-64,-34},{-58,-28}})));
  Modelica.Blocks.Sources.CombiTimeTable HVen_VDI2078(
    columns={2},
    smoothness=Modelica.Blocks.Types.Smoothness.ConstantSegments,
    tableName="HVen",
    tableOnFile=false,
    table=[0,0; 3600,0; 7200,0; 10800,0; 14400,0; 18000,0; 21600,0; 25200,
        0; 28800,0; 32400,0; 36000,8.775122167; 39600,11.77075859; 43200,
        13.80359492; 46800,14.45097624; 50400,13.58000818; 54000,
        11.36966839; 57600,8.280950332; 61200,0; 64800,0; 68400,0; 72000,
        0; 75600,0; 79200,0; 82800,0; 86400,0; 90000,0; 93600,0; 97200,0;
        100800,0; 104400,0; 108000,0; 111600,0; 115200,0; 118800,0;
        122400,8.775122167; 126000,11.77075859; 129600,13.80359492;
        133200,14.45097624; 136800,13.58000818; 140400,11.36966839;
        144000,8.280950332; 147600,0; 151200,0; 154800,0; 158400,0;
        162000,0; 165600,0; 169200,0; 172800,0; 176400,0; 180000,0;
        183600,0; 187200,0; 190800,0; 194400,0; 198000,0; 201600,0;
        205200,0; 208800,8.775122167; 212400,11.77075859; 216000,
        13.80359492; 219600,14.45097624; 223200,13.58000818; 226800,
        11.36966839; 230400,8.280950332; 234000,0; 237600,0; 241200,0;
        244800,0; 248400,0; 252000,0; 255600,0; 259200,0; 262800,0;
        266400,0; 270000,0; 273600,0; 277200,0; 280800,0; 284400,0;
        288000,0; 291600,0; 295200,8.775122167; 298800,11.77075859;
        302400,13.80359492; 306000,14.45097624; 309600,13.58000818;
        313200,11.36966839; 316800,8.280950332; 320400,0; 324000,0;
        327600,0; 331200,0; 334800,0; 338400,0; 342000,0; 345600,0;
        349200,0; 352800,0; 356400,0; 360000,0; 363600,0; 367200,0;
        370800,0; 374400,0; 378000,0; 381600,8.775122167; 385200,
        11.77075859; 388800,13.80359492; 392400,14.45097624; 396000,
        13.58000818; 399600,11.36966839; 403200,8.280950332; 406800,0;
        410400,0; 414000,0; 417600,0; 421200,0; 424800,0; 428400,0;
        432000,0; 435600,0; 439200,0; 442800,0; 446400,0; 450000,0;
        453600,0; 457200,0; 460800,0; 464400,0; 468000,0; 471600,0;
        475200,0; 478800,0; 482400,0; 486000,0; 489600,0; 493200,0;
        496800,0; 500400,0; 504000,0; 507600,0; 511200,0; 514800,0;
        518400,0; 522000,0; 525600,0; 529200,0; 532800,0; 536400,0;
        540000,0; 543600,0; 547200,0; 550800,0; 554400,0; 558000,0;
        561600,0; 565200,0; 568800,0; 572400,0; 576000,0; 579600,0;
        583200,0; 586800,0; 590400,0; 594000,0; 597600,0; 601200,0;
        604800,0; 608400,0; 612000,0; 615600,0; 619200,0; 622800,0;
        626400,0; 630000,0; 633600,0; 637200,0; 640800,8.775122167;
        644400,11.77075859; 648000,13.80359492; 651600,14.45097624;
        655200,13.58000818; 658800,11.36966839; 662400,8.280950332;
        666000,0; 669600,0; 673200,0; 676800,0; 680400,0; 684000,0;
        687600,0; 691200,0; 694800,0; 698400,0; 702000,0; 705600,0;
        709200,0; 712800,0; 716400,0; 720000,0; 723600,0; 727200,
        8.775122167; 730800,11.77075859; 734400,13.80359492; 738000,
        14.45097624; 741600,13.58000818; 745200,11.36966839; 748800,
        8.280950332; 752400,0; 756000,0; 759600,0; 763200,0; 766800,0;
        770400,0; 774000,0; 777600,0; 781200,0; 784800,0; 788400,0;
        792000,0; 795600,0; 799200,0; 802800,0; 806400,0; 810000,0;
        813600,8.775122167; 817200,11.77075859; 820800,13.80359492;
        824400,14.45097624; 828000,13.58000818; 831600,11.36966839;
        835200,8.280950332; 838800,0; 842400,0; 846000,0; 849600,0;
        853200,0; 856800,0; 860400,0; 864000,0; 867600,0; 871200,0;
        874800,0; 878400,0; 882000,0; 885600,0; 889200,0; 892800,0;
        896400,0; 900000,8.775122167; 903600,11.77075859; 907200,
        13.80359492; 910800,14.45097624; 914400,13.58000818; 918000,
        11.36966839; 921600,8.280950332; 925200,0; 928800,0; 932400,0;
        936000,0; 939600,0; 943200,0; 946800,0; 950400,0; 954000,0;
        957600,0; 961200,0; 964800,0; 968400,0; 972000,0; 975600,0;
        979200,0; 982800,0; 986400,8.775122167; 990000,11.77075859;
        993600,13.80359492; 997200,14.45097624; 1000800,13.58000818;
        1004400,11.36966839; 1008000,8.280950332; 1011600,0; 1015200,0;
        1018800,0; 1022400,0; 1026000,0; 1029600,0; 1033200,0; 1036800,0;
        1040400,0; 1044000,0; 1047600,0; 1051200,0; 1054800,0; 1058400,0;
        1062000,0; 1065600,0; 1069200,0; 1072800,0; 1076400,0; 1080000,0;
        1083600,0; 1087200,0; 1090800,0; 1094400,0; 1098000,0; 1101600,0;
        1105200,0; 1108800,0; 1112400,0; 1116000,0; 1119600,0; 1123200,0;
        1126800,0; 1130400,0; 1134000,0; 1137600,0; 1141200,0; 1144800,0;
        1148400,0; 1152000,0; 1155600,0; 1159200,0; 1162800,0; 1166400,0;
        1170000,0; 1173600,0; 1177200,0; 1180800,0; 1184400,0; 1188000,0;
        1191600,0; 1195200,0; 1198800,0; 1202400,0; 1206000,0; 1209600,0;
        1213200,0; 1216800,0; 1220400,0; 1224000,0; 1227600,0; 1231200,0;
        1234800,0; 1238400,0; 1242000,9.411054257; 1245600,14.83746656;
        1249200,19.30942141; 1252800,22.15794523; 1256400,23.03789677;
        1260000,21.85111281; 1263600,18.73088748; 1267200,14.06286399;
        1270800,0; 1274400,0; 1278000,0; 1281600,0; 1285200,0; 1288800,0;
        1292400,0; 1296000,0; 1299600,0; 1303200,0; 1306800,0; 1310400,0;
        1314000,0; 1317600,0; 1321200,0; 1324800,0; 1328400,9.411054257;
        1332000,14.83746656; 1335600,19.30942141; 1339200,22.15794523;
        1342800,23.03789677; 1346400,21.85111281; 1350000,18.73088748;
        1353600,14.06286399; 1357200,0; 1360800,0; 1364400,0; 1368000,0;
        1371600,0; 1375200,0; 1378800,0; 1382400,0; 1386000,0; 1389600,0;
        1393200,0; 1396800,0; 1400400,0; 1404000,0; 1407600,0; 1411200,0;
        1414800,9.411054257; 1418400,14.83746656; 1422000,19.30942141;
        1425600,22.15794523; 1429200,23.03789677; 1432800,21.85111281;
        1436400,18.73088748; 1440000,14.06286399; 1443600,0; 1447200,0;
        1450800,0; 1454400,0; 1458000,0; 1461600,0; 1465200,0; 1468800,0;
        1472400,0; 1476000,0; 1479600,0; 1483200,0; 1486800,0; 1490400,0;
        1494000,0; 1497600,0; 1501200,9.411054257; 1504800,14.83746656;
        1508400,19.30942141; 1512000,22.15794523; 1515600,23.03789677;
        1519200,21.85111281; 1522800,18.73088748; 1526400,14.06286399;
        1530000,0; 1533600,0; 1537200,0; 1540800,0; 1544400,0; 1548000,0;
        1551600,0; 1555200,0; 1558800,0; 1562400,0; 1566000,0; 1569600,0;
        1573200,0; 1576800,0; 1580400,0; 1584000,0; 1587600,9.411054257;
        1591200,14.83746656; 1594800,19.30942141; 1598400,22.15794523;
        1602000,23.03789677; 1605600,21.85111281; 1609200,18.73088748;
        1612800,14.06286399; 1616400,0; 1620000,0; 1623600,0; 1627200,0;
        1630800,0; 1634400,0; 1638000,0])
    "Comparison for the heat input due to ventilation with active sunblind"
    annotation (Placement(transformation(extent={{80,-38},{100,-18}})));
equation
  connect(HDifTilCle.y[1], HDifTil.u1) annotation (Line(points={{-81.3,23},
          {-62,23},{-62,16},{-42,16},{-34,16},{-33,16}}, color={0,0,127}));
  connect(HDifTilCov.y[1], HDifTil.u2) annotation (Line(points={{-81.3,1},
          {-64,1},{-64,10},{-33,10}}, color={0,0,127}));
  connect(HDifTil.y, sunblind.HDifTil) annotation (Line(points={{-21.5,13},
          {16,13},{16,4},{32,4},{32,4.32},{47.6,4.32}}, color={0,0,127}));
  connect(HDifTil.y, ventilationHeat.HDifTil) annotation (Line(points={{-21.5,
          13},{60,13},{60,5},{79,5}},             color={0,0,127}));
  connect(HDifHorCov.y[1], HDifHor.u1) annotation (Line(points={{-81.3,63},
          {-64.75,63},{-64.75,40},{-33,40}}, color={0,0,127}));
  connect(HDifHorCle.y[1], HDifHor.u2) annotation (Line(points={{-81.3,43},
          {-57.75,43},{-57.75,34},{-33,34}}, color={0,0,127}));
  connect(HDifHor.y, ventilationHeat.HDifHor) annotation (Line(points={{-21.5,
          37},{-12,37},{-12,18},{20,18},{66,18},{66,8},{79,8}},
                     color={0,0,127}));
  connect(sunblind.sunscreen, ventilationHeat.sunscreen) annotation (Line(
        points={{56.4,2},{56.4,2},{79,2}}, color={255,0,255}));
  connect(incAng.incAng, HDirTil.incAng) annotation (Line(points={{-43.4,
          -34},{-42,-34},{-42,-22.8},{-31.6,-22.8}}, color={0,0,127}));
  connect(to_HDirNor.HDirNor, HDirTil.HDirNor) annotation (Line(points={{-44.8,
          -2},{-38,-2},{-38,-13.2},{-31.6,-13.2}},         color={0,0,127}));
  connect(HDirHor.y[1], to_HDirNor.HDirHor) annotation (Line(points={{-81.3,
          -19},{-72,-19},{-72,-4},{-66,-4},{-66,0.4},{-59.2,0.4}},
                                                             color={0,0,
          127}));
  connect(alt.y[1], to_HDirNor.alt) annotation (Line(points={{-81.3,-45},
          {-81.3,-28},{-80,-28},{-76,-28},{-68,-28},{-68,-16},{-68,-6},{
          -62,-6},{-62,-4.4},{-59.2,-4.4}},
                         color={0,0,127}));
  connect(HDirTil.HDirTil, ventilationHeat.HDirTil) annotation (
  Line(points={{-13.2,
          -18},{64,-18},{64,-2},{79,-2}},        color={0,0,127}));
  connect(HDirTil.HDirTil, sunblind.HDirTil) annotation (Line(points={{-13.2,
          -18},{16,-18},{16,-0.4},{47.6,-0.4}}, color={0,0,127}));
  connect(to_HDirNor.HDirNor, ventilationHeat.HDirNor) annotation (Line(
        points={{-44.8,-2},{4,-2},{4,-32},{68,-32},{68,-4},{72,-4},{76,-4},
          {76,-5},{79,-5}}, color={0,0,127}));
  connect(alt.y[1], ventilationHeat.alt) annotation (Line(points={{-81.3,
          -45},{-80,-45},{-80,-32},{-76,-32},{-76,-56},{6,-56},{72,-56},{
          72,-8},{79,-8}}, color={0,0,127}));
  connect(incAng.decAng, decAng.decAng) annotation (Line(points={{-57.32,
          -30.76},{-57.51,-30.76},{-57.51,-31},{-57.7,-31}}, color={0,0,127}));
  connect(incAng.solHouAng, SolHouAng.solHouAng) annotation (Line(points={{
          -57.2,-36.88},{-57.45,-36.88},{-57.45,-37},{-57.7,-37}}, color={0,
          0,127}));
  annotation (experiment(StartTime=0,StopTime=1638000),Icon(coordinateSystem(
  preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)),
    Documentation(info="<html>
<p>This model simulates parts of VDI2078 test case 3. The solar irradiation is
treated as an input. To calculate the boundary conditions
<a href=\"AixLib.BoundaryConditions\">AixLib</a> models are used.</p>
</html>", revisions="<html>
<ul>
<li>July 17 2016,&nbsp; by Stanley Risch:<br/>Implemented. </li>
</ul>
</html>"));
end TestCase3_VentilationHeat;
